/*
** FCD Header treating routins
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 1999, 7/20 Quick hack version for FCD to ISO/XA convert.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define FCD_HEAD_C
#include "fcd_head.h" /* FCD Header structure's definition */

#include "binary.h" /* basic binary treating routins */

basic_fcd_header *get_basic_header(FILE *stream);
singl_track_extantion_header *get_ste_header(FILE *stream);
multi_track_extantion_header *get_mte_header(FILE *stream);
recordable_extantion_header *get_re_header(FILE *stream);

int write_basic_header(basic_fcd_header *bfh, FILE *stream);
int write_mte_header(multi_track_extantion_header *mteh, FILE *stream);

static MSF get_msf(FILE *stream);
static LBN get_lbn(FILE *stream);
static int write_msf(MSF in, FILE *stream);
static int write_lbn(LBN in, FILE *stream);

basic_fcd_header *get_basic_header(FILE *stream)
{
	basic_fcd_header *r; /* return value */

	r = (basic_fcd_header *)calloc(1,sizeof(basic_fcd_header));

	if(ftell(stream) < 0){
		/* stream is pipe? */
	}else{
		fseek(stream, 0, SEEK_SET);
	}

	read_le_int16(stream, &(r->fcd_type));
	read_le_int16(stream, &(r->orig_type));
	read_le_int32(stream, &(r->trk_offset));
	read_le_int32(stream, &(r->fcd_size));

	fread(r->desc, 1, DESC_MAX, stream);

	if(fread(r->sig, 1, SIG_MAX, stream) != SIG_MAX){
		free(r);
		return NULL;
	}
	
	if(strcmp(r->sig, SIGNATURE) != 0){
		free(r);
		return NULL;
	}

	r->data_track_start = get_lbn(stream);
	
	return r;
}

singl_track_extantion_header *get_ste_header(FILE *stream)
{
	singl_track_extantion_header *r; /* return value */

	r = (singl_track_extantion_header *)calloc(1,sizeof(singl_track_extantion_header));

	if(ftell(stream) < 0){
		/* stream is pipe? */
	}else{
		fseek(stream, STEH_OFSET, SEEK_SET);
	}

	r->first = fgetc(stream);
	r->last = fgetc(stream);
	r->total = get_lbn(stream);

	r->t1.start = get_msf(stream);
	r->t1.type = fgetc(stream);
	
	if(fread(r->reserve, 1, STEH_RSIZE, stream) != STEH_RSIZE){
		free(r);
		return NULL;
	}

	return r;
}

multi_track_extantion_header *get_mte_header(FILE *stream)
{
	int i;

	multi_track_extantion_header *r; /* return value */

	r = (multi_track_extantion_header *)calloc(1,sizeof(multi_track_extantion_header));

	if(ftell(stream) < 0){
		/* stream is pipe? */
	}else{
		fseek(stream, MTEH_OFSET, SEEK_SET);
	}

	r->track[0] = fgetc(stream);
	r->track[1] = fgetc(stream);
	r->total = get_msf(stream);

	for(i=0;i<TRACK_MAX;i++){
		r->tt[i].start = get_msf(stream);
		r->tt[i].type = fgetc(stream);
	}

	for(i=0;i<TRACK_MAX;i++){
		r->ti[i].start = get_lbn(stream);
		r->ti[i].end = get_lbn(stream);
		r->ti[i].type = fgetc(stream);
		if(fread(r->ti[i].filename, 1, FNAME_MAX, stream) != FNAME_MAX){
			free(r);
			return NULL;
		}
		if(r->tt[i].type & 0x40){
			r->ti[i].data_offset = le_char_array_to_int32(r->ti[i].filename);
        }else{
			r->ti[i].data_offset = -1;
        }          
	}

	return r;
}

recordable_extantion_header *get_re_header(FILE *stream)
{
	recordable_extantion_header *r; /* return value */

	r = (recordable_extantion_header *)calloc(1,sizeof(recordable_extantion_header));

	if(ftell(stream) < 0){
		/* stream is pipe? */
	}else{
		fseek(stream, REH_OFSET, SEEK_SET);
	}

	if(fread(r->reserve, 1, REH_SIZE, stream) != REH_SIZE){
		free(r);
		return NULL;
	}

	return r;
}

int write_basic_header(basic_fcd_header *bfh, FILE *stream)
{
	if(ftell(stream) < 0){
		/* stream is pipe? */
	}else{
		fseek(stream, 0, SEEK_SET);
	}
	
	if(!write_le_int16(bfh->fcd_type, stream)){
		return 0;
	}
	if(!write_le_int16(bfh->orig_type, stream)){
		return 0;
	}
	if(!write_le_int32(bfh->trk_offset, stream)){
		return 0;
	}
	if(!write_le_int32(bfh->fcd_size, stream)){
		return 0;
	}

	if(fwrite(bfh->desc, 1, DESC_MAX, stream) != DESC_MAX){
		return 0;
	}

	if(fwrite(bfh->sig, 1, SIG_MAX, stream) != SIG_MAX){
		return 0;
	}

	if(!write_lbn(bfh->data_track_start, stream)){
		return 0;
	}
	
	return 1;
}

int write_mte_header(multi_track_extantion_header *mteh, FILE *stream)
{
	int i,j;

	if(ftell(stream) < 0){
		/* stream is pipe? */
	}else{
		fseek(stream, MTEH_OFSET, SEEK_SET);
	}

	if(fputc(mteh->track[0], stream) == EOF){
		return 0;
	}
	if(fputc(mteh->track[1], stream) == EOF){
		return 0;
	}
	if(!write_msf(mteh->total, stream)){
		return 0;
	}

	for(i=0;i<TRACK_MAX;i++){
		if(!write_msf(mteh->tt[i].start, stream)){
			return 0;
		}
		if(fputc(mteh->tt[i].type, stream) == EOF){
			return 0;
		}
	}

	for(i=0;i<TRACK_MAX;i++){
		if(!write_lbn(mteh->ti[i].start, stream)){
			return 0;
		}
		if(!write_lbn(mteh->ti[i].end, stream)){
			return 0;
		}
		if(fputc(mteh->ti[i].type, stream) == EOF){
			return 0;
		}
		if(mteh->tt[i].type & 0x40){
			for(j=0;j<FNAME_MAX;j++){
				mteh->ti[i].filename[j] = '\0';
			}
			int32_to_le_char_array(mteh->ti[i].data_offset, mteh->ti[i].filename);
        }
		if(fwrite(mteh->ti[i].filename, 1, FNAME_MAX, stream) != FNAME_MAX){
			return 0;
		}
	}

	return 1;
}

static MSF get_msf(FILE *stream)
{
	MSF r;
	
	r.f = fgetc(stream);
	r.s = fgetc(stream);
	r.m = fgetc(stream);
	r.padding = fgetc(stream);
	
	return r;
}

static LBN get_lbn(FILE *stream)
{
	LBN r;
	int work;
	
	if(read_le_int32(stream, &work)){
		r = (LBN) work;
		return r;
	}else{
		return 0;
	}
}

static int write_msf(MSF in, FILE *stream)
{
	if(fputc(in.f, stream) == EOF){
		return 0;
	}
	if(fputc(in.s, stream) == EOF){
		return 0;
	}
	if(fputc(in.m, stream) == EOF){
		return 0;
	}
	if(fputc(0, stream) == EOF){
		return 0;
	}
	
	return 1;
}

static int write_lbn(LBN in, FILE *stream)
{
	return write_le_int32(in, stream);
}

